<?php

include 'koneksi.php';
include 'header2.php';

// Ambil data bobot dari tabel bobot2
$query = "SELECT * FROM bobot2 LIMIT 1";
$result = mysqli_query($conn, $query);
$bobot = mysqli_fetch_assoc($result);
?>

<div id="layoutSidenav_content">
    <main>
    <div class="table-responsive">
        <div class="container-fluid mt-4">
            <h3 class="text-center mb-10 py-4 bg-light rounded" style="font-size: 28px; ">
                <strong> KRITERIA DAN BOBOT</strong> 
            </h3>

            <?php if (!$bobot) : ?>
                <div class="alert alert-danger text-center" style="font-size: 20px;">
                    <strong>Data bobot tidak ditemukan!</strong> Silakan tentukan nilai bobot terlebih dahulu.
                </div>
            <?php else : ?>
                <div class="card-body">
                <div class="alert alert-info text-center mb-3 bg-success text-white" style="font-size: 20px;">
                        <i class="fas fa-info-circle"></i>  <strong>Skala Bobot = </strong> 
                            5 : Sangat Penting | 4 : Penting | 3 : Cukup Penting | 2 : Kurang Penting | 1 : Tidak Penting
                        </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered text-center w-100" style="font-size: 20px;">
                                <thead class="table-success align-middle">
                                    <tr style="height: 100px;">
                                        <th>Kode</th>
                                        <th>Kriteria</th>
                                        <th>Bobot</th>
                                        <th>Tipe</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $kriteria = [
                                        "C1" => "Jumlah Views Channel",
                                        "C2" => "Jumlah Subscribers",
                                        "C3" => "Frekuensi Upload Video Baru",
                                        "C4" => "Banyaknya Video yang Diunggah",
                                        "C5" => "Latar Belakang Pengajar/Konten Kreator"
                                    ];
                                    $tipe = [
                                        "C1" => "Benefit",
                                        "C2" => "Benefit",
                                        "C3" => "Benefit",
                                        "C4" => "Benefit",
                                        "C5" => "Benefit",
                                    ];

                                    foreach ($kriteria as $key => $nama_kriteria) :
                                        $nilai_bobot = isset($bobot[strtolower($key)]) ? $bobot[strtolower($key)] : "Data tidak tersedia";
                                    ?>
                                        <tr style="height: 90px;">
                                            <td class="align-middle"><?= $key; ?></td>
                                            <td class="align-middle text-center"><?= $nama_kriteria; ?></td>
                                            <td class="align-middle text-center"><?= $nilai_bobot; ?></td>
                                            <td class="align-middle text-center"><?= $tipe[$key]; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <br>

            <div class="text-center">
                <?php if (!$bobot) : ?>
                    <a href="ubah_bobot2.php" class="btn btn-lg btn-success" style="font-size: 22px; padding: 12px 24px;">
                        <i class="fas fa-plus"></i> Tentukan Nilai Bobot Kriteria
                    </a>
                <?php else : ?>
                    <a href="ubah_bobot2.php" class="btn btn-lg btn-warning" style="font-size: 22px; padding: 12px 24px;">
                        <i class="fas fa-edit"></i> Ubah Bobot
                    </a>
                <?php endif; ?>
            </div>

        </div>
    </main>
</div>

<!-- Pastikan navigasi bisa dibuka dan tidak macet -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>
